 ; Ŀ
 ;   Gouge - Write block definitions to a file.  This is the whole thing   
 ;   from the block table, not just the attributes from one insertion.     
 ;   Copyright 1994, 2010 by Rocket Software Ltd.                          
 ;                                                                         
 ;   Notes: 1. Entnext returns nil after the last entity in a block        
 ;             definition.                                                 
 ;          2. An empty block has one subentity of type Endblk.            
 ; 

 (DEFUN FILM (aa / pos len bb aa)
  (setq pos 1)
  (setq len (strlen aa))
  (while (>= len pos)
         (setq bb (substr aa pos 1))
         (if (= bb "*")
             (setq aa (strcat (substr aa 1 (1- pos)) (substr aa (1+ pos))))
             (setq pos (1+ pos))))
  (setq aa (strcat (strcase (substr aa 1 8) t) ".lst")))


 (DEFUN C:GOUGE (/ blnam typp blok filp filnam subfil namm entt)
  (setq blnam (getstring t "Block name or <Return> to pick: "))
  (if (= blnam "")
      (progn
           (setq blnam (entsel "Select block: "))
           (if blnam (setq typp (cdr (assoc 0 (entget (car blnam))))))
           (if (or (= typp "INSERT")
                   (= typp "DIMENSION"))
               (setq blnam (cdr (assoc 2 (entget (car blnam)))))
               (progn
                    (setq blnam ())
                    (write-line "\nThat wasn't a block")))))
  (if blnam
     (progn
          (if (setq blok (tblsearch "block" blnam))       ; get head entity
              (progn
                   (setq filp (film blnam))
                   (setq filnam (getstring (strcat "\nFilename <" filp ">: ")))
                   (if (= filnam "") (setq filnam filp))
                   (if (findfile filnam)
                       (progn
                            (initget 0 "Overwrite Append Quit")
                            (setq quipt (getkword (strcat
                                          "That file already exists."
                                          "  Overwrite, Append, or <Quit>? ")))
                            (if (null quipt) (setq quipt "Quit"))))
                   (cond ((or (null quipt)
                              (= quipt "Append"))
                          (setq subfil (open filnam "a"))
                          (if (null subfil)
                              (write-line "Unable to open that file")))
                         ((= quipt "Overwrite")
                          (setq subfil (open filnam "w"))
                          (close subfil)
                          (setq subfil (open filnam "a"))
                          (if (null subfil)
                              (write-line "Unable to open that file")))
                         ((= quipt "Quit")
                          (setq subfil ()))))
              (write-line "\nCan't find that block."))))
  (if subfil                                     ; if successful file open
      (progn
           (prin1 blok subfil)                   ; write to the file
           (write-line "" subfil)                ; add a line feed
           (setq namm (cdr (assoc -2 blok)))     ; first ename after head
           (while namm                           ; while there is an entity
                  (setq entt (entget namm))      ; the whole thing
                  (prin1 entt subfil)            ; write to the file
                  (write-line "" subfil)         ; add a line feed
                  (setq namm (entnext namm)))    ; next subentity ename
           (close subfil)))                      ; finished, so close file
 (princ))